/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.IRemoteConnection;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import java.awt.Container;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrument {
    private static final String IP_LIST_KEY = "ip_list";
    private static final String LAST_IP_KEY = "last_ip";
    private static IQDConsole m_defaultConsole = null;
    private static IQDPluginContext m_appContext = null;
    private static Vector<InstrumentListener> m_listeners = new Vector();
    private static JComponent m_defaultComp;
    private static Map<JComponent, RemoteInstrument> m_imap;

    public static void setDefaultConsole(IQDConsole iQDConsole) {
        m_defaultConsole = iQDConsole;
    }

    public static void setContext(IQDPluginContext iQDPluginContext) {
        m_appContext = iQDPluginContext;
    }

    public static void setDefaultComponent(JComponent jComponent) {
        m_defaultComp = jComponent;
    }

    public static synchronized RemoteInstrument get(JComponent jComponent) {
        return m_imap.get(jComponent);
    }

    public static synchronized RemoteInstrument getDefault() {
        return m_imap.get(m_defaultComp);
    }

    public static void initAppletInstrument() {
        RemoteInstrument remoteInstrument = m_appContext.getConnectionManager().getAppletInstrument();
        if (remoteInstrument != null && remoteInstrument.isConnected()) {
            m_imap.put(m_defaultComp, remoteInstrument);
            Instrument.notifyConnected(remoteInstrument);
        }
    }

    public static synchronized void addListener(InstrumentListener instrumentListener) {
        m_listeners.add(instrumentListener);
    }

    public static synchronized void removeListener(InstrumentListener instrumentListener) {
        m_listeners.remove(instrumentListener);
    }

    private static void notifyConnected(RemoteInstrument remoteInstrument) {
        SwingUtilities.invokeLater(new Notifier(remoteInstrument, true));
    }

    private static void notifyDisconnected(RemoteInstrument remoteInstrument) {
        SwingUtilities.invokeLater(new Notifier(remoteInstrument, false));
    }

    public static synchronized void unregister(JComponent jComponent) {
        RemoteInstrument remoteInstrument = m_imap.remove(jComponent);
        if (remoteInstrument != null) {
            if (Instrument.get(remoteInstrument.getConnection().getName()) == null) {
                remoteInstrument.disconnect();
            }
            if (!remoteInstrument.isConnected()) {
                Instrument.notifyDisconnected(remoteInstrument);
            }
        }
    }

    public static synchronized void register(JComponent jComponent, RemoteInstrument remoteInstrument) {
        m_imap.put(jComponent, remoteInstrument);
    }

    public static synchronized RemoteInstrument connect(JComponent jComponent) {
        String string = Instrument.getInstrumentIP(jComponent);
        if (string.length() == 0) {
            return null;
        }
        Instrument.unregister(jComponent);
        RemoteInstrument remoteInstrument = Instrument.get(string);
        if (remoteInstrument == null) {
            SocketConnection socketConnection = new SocketConnection(string);
            remoteInstrument = new RemoteInstrument((IRemoteConnection)socketConnection, m_defaultConsole);
        }
        try {
            remoteInstrument.connect(2000);
            if (m_imap.size() == 0) {
                m_imap.put(m_defaultComp, remoteInstrument);
            }
            m_imap.put(jComponent, remoteInstrument);
            Instrument.notifyConnected(remoteInstrument);
            Instrument.saveIP(string);
        }
        catch (InstrumentException instrumentException) {
            String string2 = "Unable to connect to: " + remoteInstrument.getConnection().getName();
            MsgLog.error(string2 + " - " + remoteInstrument.getErrorMessage());
            JOptionPane.showMessageDialog(jComponent, string2 + "\n" + remoteInstrument.getErrorMessage(), "Connection Failed", 0, null);
            Instrument.notifyDisconnected(remoteInstrument);
            return null;
        }
        return remoteInstrument;
    }

    public static synchronized String getUnitType(RemoteInstrument remoteInstrument) throws InstrumentException {
        if (remoteInstrument == null) {
            return null;
        }
        String string = remoteInstrument.tryQuery("*IDN?");
        String[] stringArray = string.split(",");
        if (stringArray.length > 1 && (stringArray = stringArray[1].split("-")).length != 0) {
            return stringArray[0];
        }
        return null;
    }

    public static boolean is882L(RemoteInstrument remoteInstrument) throws InstrumentException {
        double d;
        if (remoteInstrument == null) {
            return false;
        }
        String string = remoteInstrument.tryQuery("*IDN?");
        String[] stringArray = string.split(",");
        return stringArray.length >= 4 && (d = Double.parseDouble(stringArray[3])) > 29.0;
    }

    private static synchronized String getInstrumentIP(JComponent jComponent) {
        int n;
        Object object2;
        RemoteInstrument remoteInstrument = Instrument.get(jComponent);
        Vector<String> vector = new Vector<String>();
        String string = null;
        if (remoteInstrument != null) {
            string = remoteInstrument.getConnection().getName();
            if (string.length() > 0) {
                vector.add(string);
            } else {
                string = null;
            }
        }
        if (string == null) {
            object2 = Preferences.userNodeForPackage(Instrument.class);
            string = ((Preferences)object2).get(LAST_IP_KEY, null);
        }
        for (RemoteInstrument object3 : m_imap.values()) {
            Instrument.addIP(object3.getConnection().getName(), vector);
        }
        Instrument.addSavedIPs(vector);
        Collections.sort(vector);
        object2 = new JPanel();
        JLabel jLabel = new JLabel("Enter an IP Address:");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        ((Container)object2).add(jLabel);
        JComboBox<Object> jComboBox = new JComboBox<Object>(vector.toArray());
        if (string != null) {
            for (n = 0; n < vector.size(); ++n) {
                if (!vector.get(n).equals(string)) continue;
                jComboBox.setSelectedIndex(n);
                break;
            }
        }
        jComboBox.setEditable(true);
        ((Container)object2).add(jComboBox);
        n = JOptionPane.showConfirmDialog(jComponent, object2, "Connect to?", 2);
        if (n == 2) {
            return "";
        }
        return (String)jComboBox.getEditor().getItem();
    }

    private static void addIP(String string, Vector<String> vector) {
        for (String string2 : vector) {
            if (!string2.equals(string)) continue;
            string = null;
            break;
        }
        if (string != null) {
            vector.add(string);
        }
    }

    private static RemoteInstrument get(String string) {
        for (RemoteInstrument remoteInstrument : m_imap.values()) {
            if (!remoteInstrument.getConnection().getName().equals(string)) continue;
            return remoteInstrument;
        }
        return null;
    }

    private static void addSavedIPs(Vector<String> vector) {
        String[] stringArray;
        Preferences preferences = Preferences.userNodeForPackage(Instrument.class);
        String string = preferences.get(IP_LIST_KEY, "192.168.254.106");
        for (String string2 : stringArray = string.split(";")) {
            Instrument.addIP(string2, vector);
        }
    }

    private static void saveIP(String string) {
        Vector<String> vector = new Vector<String>();
        Instrument.addSavedIPs(vector);
        Instrument.addIP(string, vector);
        if (vector.size() > 10) {
            vector.remove(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (String string2 : vector) {
            if (n > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(string2);
            ++n;
        }
        Preferences preferences = Preferences.userNodeForPackage(Instrument.class);
        preferences.put(IP_LIST_KEY, stringBuilder.toString());
        preferences.put(LAST_IP_KEY, string);
    }

    public static void dump() {
        System.out.println("Default Comp: " + (m_defaultComp == null ? "NULL" : m_defaultComp.getClass().getName()));
        int n = 0;
        for (JComponent jComponent : m_imap.keySet()) {
            RemoteInstrument remoteInstrument = m_imap.get(jComponent);
            System.out.println("R" + n + " = " + jComponent.getClass().getName() + " @ " + remoteInstrument.getConnection().getName());
            ++n;
        }
        System.out.println("Listener Count: " + m_listeners.size());
    }

    static {
        m_imap = new TreeMap<JComponent, RemoteInstrument>(new CompCompare());
    }

    private static class Notifier
    implements Runnable {
        private boolean m_connect;
        private RemoteInstrument m_instr;

        public Notifier(RemoteInstrument remoteInstrument, boolean bl) {
            this.m_instr = remoteInstrument;
            this.m_connect = bl;
        }

        public void run() {
            for (InstrumentListener instrumentListener : m_listeners) {
                if (this.m_connect) {
                    instrumentListener.connected(this.m_instr);
                    continue;
                }
                instrumentListener.disconnected(this.m_instr);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompCompare
    implements Comparator<JComponent> {
        private CompCompare() {
        }

        @Override
        public int compare(JComponent jComponent, JComponent jComponent2) {
            return jComponent.getName().compareTo(jComponent2.getName());
        }
    }
}

